<?php
/************************************************************************
 * This file is part of EspoCRM.
 *
 * EspoCRM – Open Source CRM application.
 * Copyright (C) 2014-2026 EspoCRM, Inc.
 * Website: https://www.espocrm.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "EspoCRM" word.
 ************************************************************************/

namespace Espo\Tools\OpenApi\Api;

use Espo\Core\Acl;
use Espo\Core\Api\Action;
use Espo\Core\Api\Request;
use Espo\Core\Api\Response;
use Espo\Core\Api\ResponseComposer;
use Espo\Core\Exceptions\Forbidden;
use Espo\Tools\OpenApi\Provider\Params;
use Espo\Tools\OpenApi\ProviderFactory;

/**
 * @noinspection PhpUnused
 */
class GetSpec implements Action
{
    private const string SCOPE = 'OpenApi';

    public function __construct(
        private Acl $acl,
        private ProviderFactory $providerFactory,
    ) {}

    public function process(Request $request): Response
    {
        $this->checkAccess();

        $provider = $this->providerFactory->create();

        $skipCustom = $request->getQueryParam('skipCustom') === 'true';
        $module = $request->getQueryParam('module');

        $params = new Params(
            skipCustom: $skipCustom,
            module: $module,
        );

        $spec = $provider->get($params);

        return ResponseComposer::empty()
            ->writeBody($spec)
            ->setHeader('Content-Type', 'application/json');
    }

    /**
     * @throws Forbidden
     */
    private function checkAccess(): void
    {
        if (!$this->acl->checkScope(self::SCOPE)) {
            throw new Forbidden("No access to OpenApi scope.");
        }
    }
}
