<?php
/************************************************************************
 * This file is part of EspoCRM.
 *
 * EspoCRM - Open Source CRM application.
 * Copyright (C) 2014-2015 Yuri Kuznetsov, Taras Machyshyn, Oleksiy Avramenko
 * Website: http://www.espocrm.com
 *
 * EspoCRM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EspoCRM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EspoCRM. If not, see http://www.gnu.org/licenses/.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "EspoCRM" word.
 ************************************************************************/

namespace Espo\Core\Upgrades\Actions;
use Espo\Core\Exceptions\Error;

class Helper
{
    private $actionObject;

    public function __construct($actionObject = null)
    {
        if (isset($actionObject)) {
            $this->setActionObject($actionObject);
        }
    }

    public function setActionObject(\Espo\Core\Upgrades\Actions\Base $actionObject)
    {
        $this->actionObject = $actionObject;
    }

    protected function getActionObject()
    {
        return $this->actionObject;
    }

    /**
     * Check dependencies
     *
     * @param  array | string $dependencyList
     *
     * @return bool
     */
    public function checkDependencies($dependencyList)
    {
        if (!is_array($dependencyList)) {
            $dependencyList = (array) $dependencyList;
        }

        $actionObject = $this->getActionObject();

        foreach ($dependencyList as $extensionName => $extensionVersion) {
            $dependencyExtensionEntity = $actionObject->getEntityManager()->getRepository('Extension')->where(array(
                'name' => trim($extensionName),
                'isInstalled' => true,
            ))->findOne();

            $errorMessage = 'Dependency Error: The extension "'.$extensionName.'" with version "'.$extensionVersion.'" is missing.';
            if (!isset($dependencyExtensionEntity) || !$actionObject->checkVersions($extensionVersion, $dependencyExtensionEntity->get('version'), $errorMessage)) {
                throw new Error($errorMessage);
            }
        }

        return true;
    }
}
