/************************************************************************
 * This file is part of EspoCRM.
 *
 * EspoCRM - Open Source CRM application.
 * Copyright (C) 2014  Yuri Kuznetsov, Taras Machyshyn, Oleksiy Avramenko
 * Website: http://www.espocrm.com
 *
 * EspoCRM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EspoCRM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EspoCRM. If not, see http://www.gnu.org/licenses/.
 ************************************************************************/ 

Espo.define('Views.Role.Record.Detail', 'Views.Record.Detail', function (Dep) {

	return Dep.extend({
	
		sideView: null,
		
		editModeEnabled: false,

		getDetailLayout: function (callback) {
			var simpleLayout = [
				{
					label: '',
					cells: [
						{
							name: 'name',
							type: 'base',
						},						
					]
				}			
			];		
			callback({
				type: 'record',
				layout: this._convertSimplifiedLayout(simpleLayout)
			});
		},
	
		setup: function () {
			Dep.prototype.setup.call(this);			
			this.createView('extra', 'Role.Record.Table', {
				aclData: JSON.parse(this.model.get('data') || '{}') || {}
			});							
		},
	});
});


