/************************************************************************
 * This file is part of EspoCRM.
 *
 * EspoCRM - Open Source CRM application.
 * Copyright (C) 2014  Yuri Kuznetsov, Taras Machyshyn, Oleksiy Avramenko
 * Website: http://www.espocrm.com
 *
 * EspoCRM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EspoCRM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EspoCRM. If not, see http://www.gnu.org/licenses/.
 ************************************************************************/ 

Espo.Collection = Backbone.Collection.extend({

	name: null,

	total: 0,

	offset: 0,

	maxSize: 20,

	sortBy: 'id',

	asc: false,

	where: null,

	_user: null,

	initialize: function (models, options) {
		options = options || {};
		this.name = options.name || this.name;
		this.urlRoot = this.urlRoot || this.name;
		this.url = this.url || this.urlRoot;
		
		this.sortBy = options.sortBy || this.sortBy;
		this.asc = ('asc' in options) ? options.asc : this.asc;

		Backbone.Collection.prototype.initialize.call(this);
	},

	sort: function (field, asc) {
		this.sortBy = field;
		this.asc = asc;
		this.fetch();
	},

	nextPage: function () {
		var offset = this.offset + this.maxSize;
		this.setOffset(offset);
	},

	previousPage: function () {
		var offset = this.offset - this.maxSize;
		this.setOffset(offset);
	},

	firstPage: function () {
		this.setOffset(0);
	},

	lastPage: function () {
		var offset = this.total - this.total % this.maxSize;
		this.setOffset(offset);
	},

	setOffset: function (offset) {
		if (offset < 0) {
			throw new RangeError('offset can not be less than 0');
		}
		if (offset > this.total) {
			throw new RangeError('offset can not be larger than total count');
		}
		this.offset = offset;
		this.fetch();
	},

	parse: function (response) {
		this.total = response.total;
		return response.list;
	},

	fetch: function (options) {
		var options = options || {};
		options.data = options.data || {};

		this.offset = options.offset || this.offset;
		this.sortBy = options.sortBy || this.sortBy;
		this.asc = options.asc || this.asc;
		this.where = options.where || this.where;

		if (!('maxSize' in options)) {
			options.data.maxSize = options.more ? this.maxSize : ((this.length > this.maxSize) ? this.length : this.maxSize);
		} else {
			options.data.maxSize = options.maxSize;
		}
		
		options.data.offset = options.more ? this.length : this.offset;
		options.data.sortBy = this.sortBy;
		options.data.asc = this.asc;
		options.data.where = this.where;
		
		return Backbone.Collection.prototype.fetch.call(this, options);
	},

	getUser: function () {
		return this._user;
	},
});


