<?php
/************************************************************************
 * This file is part of EspoCRM.
 *
 * EspoCRM - Open Source CRM application.
 * Copyright (C) 2014  Yuri Kuznetsov, Taras Machyshyn, Oleksiy Avramenko
 * Website: http://www.espocrm.com
 *
 * EspoCRM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EspoCRM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EspoCRM. If not, see http://www.gnu.org/licenses/.
 ************************************************************************/

namespace Espo\Core\Loaders;

use Doctrine\ORM\Tools\Setup,
    Espo\Core\Doctrine\ORM\Mapping\Driver\EspoPHPDriver;

class EntityManager
{
	private $container;

	public function __construct(\Espo\Core\Container $container)
	{
		$this->container = $container;
	}

	protected function getContainer()
	{
    	return $this->container;
	}

	public function load()
	{
		$config = $this->getContainer()->get('config');

		$params = array(
			'host' => $config->get('database.host'),
			'port' => $config->get('database.port'),
			'dbname' => $config->get('database.dbname'),
			'user' => $config->get('database.user'),
			'password' => $config->get('database.password'),
			'metadata' => $this->getContainer()->get('metadata')->getOrmMetadata(),
			'repositoryFactoryClassName' => '\\Espo\\Core\\ORM\\RepositoryFactory',
		);

		$entityManager = new \Espo\Core\ORM\EntityManager($params);
		$entityManager->setEspoMetadata($this->getContainer()->get('metadata'));
		$entityManager->setHookManager($this->getContainer()->get('hookManager'));
		$entityManager->setContainer($this->getContainer());

		return $entityManager;
	}
}

