<?php
/************************************************************************
 * This file is part of EspoCRM.
 *
 * EspoCRM - Open Source CRM application.
 * Copyright (C) 2014  Yuri Kuznetsov, Taras Machyshyn, Oleksiy Avramenko
 * Website: http://www.espocrm.com
 *
 * EspoCRM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EspoCRM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EspoCRM. If not, see http://www.gnu.org/licenses/.
 ************************************************************************/

namespace Espo\Controllers;

use Espo\Core\Utils as Utils;
use \Espo\Core\Exceptions\NotFound;
use \Espo\Core\Exceptions\Error;

class Layout extends \Espo\Core\Controllers\Base
{
    public function actionRead($params, $data)
	{
		$data = $this->getContainer()->get('layout')->get($params['scope'], $params['name']);
		if (empty($data)) {
			throw new NotFound("Layout " . $params['scope'] . ":" . $params['name'] . ' is not found');
		}
		return $data;
	}

	public function actionUpdate($params, $data)
	{
        $result = $this->getContainer()->get('layout')->set($data, $params['scope'], $params['name']);

		if ($result === false) {
			throw new Error("Error while saving layout");
		}

		$this->getContainer()->get('dataManager')->updateCacheTimestamp();

		return $this->getContainer()->get('layout')->get($params['scope'], $params['name']);
	}

	public function actionPatch($params, $data)
	{
        return $this->actionUpdate($params, $data);
	}
}
